Ext.data.JsonP.sol_common_as_Utils({"tagname":"class","name":"sol.common.as.Utils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.as.Utils.js","href":"lib_sol.common.as.Utils.html#sol-common-as-Utils"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.0"],"eloas":true,"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"checkAdminOnly","tagname":"method","owner":"sol.common.as.Utils","id":"method-checkAdminOnly","meta":{}},{"name":"cleanupUserSession","tagname":"method","owner":"sol.common.as.Utils","id":"method-cleanupUserSession","meta":{}},{"name":"downloadFonts","tagname":"method","owner":"sol.common.as.Utils","id":"method-downloadFonts","meta":{}},{"name":"ensureRelogin","tagname":"method","owner":"sol.common.as.Utils","id":"method-ensureRelogin","meta":{"private":true}},{"name":"executeFunction","tagname":"method","owner":"sol.common.as.Utils","id":"method-executeFunction","meta":{}},{"name":"getAsVersion","tagname":"method","owner":"sol.common.as.Utils","id":"method-getAsVersion","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"isDebugger","tagname":"method","owner":"sol.common.as.Utils","id":"method-isDebugger","meta":{}},{"name":"requiresUserSession","tagname":"method","owner":"sol.common.as.Utils","id":"method-requiresUserSession","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.as.Utils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.as.Utils</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.as.Utils.html#sol-common-as-Utils' target='_blank'>lib_sol.common.as.Utils.js</a></div></pre><div class='doc-contents'><p>Utility methods for the ELOas.</p>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-checkAdminOnly' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.Utils'>sol.common.as.Utils</span><br/><a href='source/lib_sol.common.as.Utils.html#sol-common-as-Utils-method-checkAdminOnly' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.Utils-method-checkAdminOnly' class='name expandable'>checkAdminOnly</a>( <span class='pre'>funcName, config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether the function is called by an administrative user ...</div><div class='long'><p>Checks wether the function is called by an administrative user</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>funcName</span> : String<div class='sub-desc'><p>Function name</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n</div></li></ul></div></div></div><div id='method-cleanupUserSession' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.Utils'>sol.common.as.Utils</span><br/><a href='source/lib_sol.common.as.Utils.html#sol-common-as-Utils-method-cleanupUserSession' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.Utils-method-cleanupUserSession' class='name expandable'>cleanupUserSession</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Changed connection settings (see requiresUserSession) will be reseted and the user connection will be closed. ...</div><div class='long'><p>Changed connection settings (see <a href=\"#!/api/sol.common.as.Utils-method-requiresUserSession\" rel=\"sol.common.as.Utils-method-requiresUserSession\" class=\"docClass\">requiresUserSession</a>) will be reseted and the user connection will be closed.</p>\n</div></div></div><div id='method-downloadFonts' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.Utils'>sol.common.as.Utils</span><br/><a href='source/lib_sol.common.as.Utils.html#sol-common-as-Utils-method-downloadFonts' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.Utils-method-downloadFonts' class='name expandable'>downloadFonts</a>( <span class='pre'>params</span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Download fonts ...</div><div class='long'><p>Download fonts</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>fontFolderRepoPaths</span> : String[]<div class='sub-desc'><p>Font folder repository path</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>Font temporary directory paths</p>\n</div></li></ul></div></div></div><div id='method-ensureRelogin' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.Utils'>sol.common.as.Utils</span><br/><a href='source/lib_sol.common.as.Utils.html#sol-common-as-Utils-method-ensureRelogin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.Utils-method-ensureRelogin' class='name expandable'>ensureRelogin</a>( <span class='pre'>[conn]</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Ensure a re-login if necessary ...</div><div class='long'><p>Ensure a re-login if necessary</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>conn</span> : de.elo.ix.client.IXConnection (optional)<div class='sub-desc'><p>Connection</p>\n<p>Defaults to: <code>ixConnect</code></p></div></li></ul></div></div></div><div id='method-executeFunction' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.Utils'>sol.common.as.Utils</span><br/><a href='source/lib_sol.common.as.Utils.html#sol-common-as-Utils-method-executeFunction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.Utils-method-executeFunction' class='name expandable'>executeFunction</a>( <span class='pre'>funcName, config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Executes an function ...</div><div class='long'><p>Executes an function</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>funcName</span> : String<div class='sub-desc'><p>Function name</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n</div></li><li><span class='pre'>adminOnly</span> : Object (optional)<div class='sub-desc'><p>If true then the function can only be called by an user with administrative rights</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>rawResult</span> : Boolean<div class='sub-desc'><p>Returns the raw result</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-getAsVersion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.Utils'>sol.common.as.Utils</span><br/><a href='source/lib_sol.common.as.Utils.html#sol-common-as-Utils-method-getAsVersion' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.Utils-method-getAsVersion' class='name expandable'>getAsVersion</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the version of the ELOas ...</div><div class='long'><p>Returns the version of the ELOas</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-isDebugger' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.Utils'>sol.common.as.Utils</span><br/><a href='source/lib_sol.common.as.Utils.html#sol-common-as-Utils-method-isDebugger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.Utils-method-isDebugger' class='name expandable'>isDebugger</a>( <span class='pre'></span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns true if the code runs within the ELOas debugger ...</div><div class='long'><p>Returns true if the code runs within the ELOas debugger</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-requiresUserSession' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.Utils'>sol.common.as.Utils</span><br/><a href='source/lib_sol.common.as.Utils.html#sol-common-as-Utils-method-requiresUserSession' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.Utils-method-requiresUserSession' class='name expandable'>requiresUserSession</a>( <span class='pre'>scope</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks if the current execution is in an users context and throws an exception if that is not the case. ...</div><div class='long'><p>Checks if the current execution is in an users context and throws an exception if that is not the case.</p>\n\n<p>If an EM_USERID is set, <code>ixConnect</code> will be initialized for this user, while the original connection will be availabe via <code>ixConnectAdmin</code>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>scope</span> : Object<div class='sub-desc'><p>The ruleset object</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"singleton":true}});